<?php
add_action("init", function(){
    $ariawp_license = new ariawp_license("gravityforms", "gravityforms", "افزونه گرویتی فرم", "4335", __DIR__);
});

if(!class_exists("ariawp_license"))
{
    class ariawp_license
    {
        private $id;
        private $title;
        private $names;
        private $product_id;

        public function __construct($id, $folder, $title, $product_id, $directory)
        {
            $this->id = $id;
            $this->folder = $folder;
            $this->title = $title;
            $this->product_id = $product_id;
            $this->directory = $directory;
            $this->base_key = "ariawp_license_licenses_general_" . $this->id;
            $this->location = $this->where_am_i($this->directory);

            add_filter("ariawp_license_licenses", [$this, "add_new_license"], 1);
            add_action("admin_init", [$this, "check_license"]);
            
            if($this->location == "plugin" || $this->location == "mu-plugin")
            {
                add_filter('pre_set_site_transient_update_plugins', [$this, 'add_update_notice'], 100);
            }
            else
            {
                add_filter('pre_set_site_transient_update_themes', [$this, 'add_update_notice'], 100);
            }
        }

        private function server_address()
        {
            return "https://ariawp.com/";
        }

        public function add_new_license($fields)
        {
            array_push($fields,
                [
                    "id" => $this->id,
                    "tab" => "licenses",
                    "section" => "general",
                    "label" => __(sprintf("لایسنس %s", $this->title), "ariawp-license"),
                    "desc" =>
                        __(sprintf("کد لایسنس %s را اینجا وارد کنید.", $this->title), "ariawp-license"),
                    "type" => "text",
                    "default" => "",
                ],
            );

            return $fields;
        }

        public function where_am_i($directory) 
        {
            $current_directory = $this->forward_slashes($directory);
            $plugins_directory = $this->forward_slashes(WP_PLUGIN_DIR);
            $mu_plugins_directory = $this->forward_slashes(WPMU_PLUGIN_DIR);
            $themes_directory = $this->forward_slashes(get_theme_root());

            if ( strpos ( $current_directory, $plugins_directory ) !== FALSE ) {
                $location = 'plugin';

            } elseif ( strpos ( $current_directory, $mu_plugins_directory ) !== FALSE ) {
                $location = 'mu-plugin';

            } elseif ( strpos ( $current_directory, $themes_directory ) !== FALSE ) {
                $stylesheet_directory = $this->forward_slashes(get_stylesheet_directory());

                if ( is_child_theme() && ( strpos ( $current_directory, $stylesheet_directory ) !== FALSE ) ) {
                    $location = 'child-theme';
                } else {
                    $location = 'theme';
                }

            } else {
                $location = FALSE;
            }

            return $location;
        }

        public function forward_slashes($string) 
        {
            return str_replace('\\', '/', $string);
        }

        public function add_update_notice($transient)
        {
            $license = get_option($this->base_key, false);
            $license_activated = get_option($this->base_key . "_activated", false);
            $license_instance = get_option($this->base_key . "_instance", false);

            $cur_version = "1.0.0";

            if($this->location == "plugin" || $this->location == "mu-plugin")
            {
                $plugin_data = get_plugin_data(WP_CONTENT_DIR . "/plugins/" . $this->folder . "/" . $this->id . ".php");
                $cur_version = $plugin_data['Version'];
            }
            else
            {
                $cur_version = wp_get_theme()->get('Version');
            }

            $json = false;
            
            try
            {
                $response = wp_remote_get(
                    $this->server_address() . "?wc-api=wc-am-api&wc_am_action=update&product_id=" . 
                    $this->product_id . 
                    "&api_key=" . 
                    $license . 
                    "&instance=" .
                    $license_instance .
                    "&version=" .
                    $cur_version .
                    "&plugin_name=" . 
                    $this->id . "/" . $this->id . ".php" .
                    "&slug=" . 
                    $this->id . "/" . $this->id . ".php"
                );

                if (is_array($response) && !is_wp_error($response)) {
                    $json = $response['body'];
                }
            }
            catch (Exception $e) {}

            if($json != false && strlen($json) > 0)
            {
                $json = json_decode($json, true);

                if(isset($json["data"]["package"]["package"]) && $json["data"]["package"]["package"] != "")
                {
                    if(version_compare($json["data"]["package"]["new_version"], $cur_version) > 0)
                    {
                        $response = (array)$json["data"]["package"];

                        if($this->location == "theme" || $this->location == "child-theme")
                        {
                            $stylesheet = get_template();
                            $response["theme"] = $stylesheet;
                            $transient->response[$stylesheet] = (array)$response;
                        }
                        else
                        {
                            $transient->response[$this->id . "/" . $this->id . ".php"] = (array)$response;
                        }
                    }
                }
            }

            return $transient;
        }

        public function check_license()
        {
            $license = get_option($this->base_key, false);
            $license_activated = get_option($this->base_key . "_activated", false);
            $license_inactive = get_option($this->base_key . "_inactive", false);
            $license_instance = get_option($this->base_key . "_instance", false);

            if($license_inactive == true)
            {
                if(isset($_POST["delete_license"]))
                {
                    update_option($this->base_key, "");
                    update_option($this->base_key . "_activated", "");
                    update_option($this->base_key . "_inactive", "");
                }
                else
                {
                    add_action("admin_notices", [$this, "inactive_license_notice"]);
                }
            }
            else if($license == false || $license != $license_activated)
            {
                $site_url = site_url();
                $url = preg_replace("(^https?://)", "", $site_url );

                if($license_instance == false)
                {
                    $alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
                    $license_instance = [];
                    $alphaLength = strlen($alphabet) - 1;
                    for ($i = 0; $i < 10; $i++) {
                        $n = rand(0, $alphaLength);
                        $license_instance[] = $alphabet[$n];
                    }

                    update_option($this->base_key . "_instance", implode($license_instance));
                    $license_instance = implode($license_instance);
                }
                
                $json = false;
            
                try
                {
                    $response = wp_remote_get(
                        $this->server_address() . "?wc-api=wc-am-api&wc_am_action=activate&product_id=" . 
                        $this->product_id . 
                        "&api_key=" . 
                        $license . 
                        "&instance=" .
                        $license_instance .
                        "&object=" . 
                        $url
                    );

                    if (is_array($response) && !is_wp_error($response)) {
                        $json = $response['body'];
                    }
                }
                catch (Exception $e) {}

                if($json != false && strlen($json) > 0)
                {
                    $json = json_decode($json, true);

                    if($json["success"] == true)
                    {
                        update_option($this->base_key . "_activated", $license);
                        update_option($this->base_key . "_success_seen", false);
                    }
                    else
                    {
                        add_action("admin_notices", [$this, "error_activation_notice"]);
                        update_option($this->base_key . "_activated", false);
                        update_option($this->base_key . "_success_seen", true);
                    }

                    if(isset($json["error"]))
                    {
                        if($json["error"] == "Cannot activate API Key. The API Key has already been activated with the same unique instance ID sent with this request.")
                        {
                            update_option($this->base_key . "_instance", "");
                        }
                        else if($json["error"] == "Cannot activate API Key. No API Resources available.")
                        {
                            add_action("admin_notices", [$this, "max_activation_notice"]);
                        }
                    }
                }
            }
            else
            {
                $license_check_time = get_option($this->base_key . "_check_time", false);

                if($license_check_time == false || time() > $license_check_time + 7200)
                {
                    $json = false;
                
                    try
                    {
                        $response = wp_remote_get(
                            $this->server_address() . "?wc-api=wc-am-api&wc_am_action=status&product_id=" . 
                            $this->product_id . 
                            "&api_key=" . 
                            $license . 
                            "&instance=" .
                            $license_instance
                        );

                        if (is_array($response) && !is_wp_error($response)) {
                            $json = $response['body'];
                        }
                    }
                    catch (Exception $e) {}

                    if($json != false && strlen($json) > 0)
                    {
                        $json = json_decode($json, true);

                        if((isset($json["status_check"]) && $json["status_check"] == "inactive") || $json["success"] == false)
                        {
                            update_option($this->base_key . "_inactive", true);
                        }
                        else
                        {
                            update_option($this->base_key . "_check_time", time());
                        }
                    }
                }
            }

            if(isset($_POST["success_seen"]))
            {
                update_option($this->base_key . "_success_seen", true);
            }
            else
            {
                if(get_option($this->base_key . "_success_seen", false) == false)
                {
                    add_action("admin_notices", [$this, "activation_notice"]);
                }
            }
        }

        public function activation_notice()
        {
            ?>
            <div class="updated notice">
                <h1><?php _e(sprintf("لایسنس %s", $this->title), "ariawp-license"); ?></h1>
                <p><?php _e(sprintf("لایسنس %s (آریا وردپرس) فعال شده است.", $this->title), "ariawp-license"); ?>
                    <form method="post">
                        <input type="submit" name="success_seen" class="button button-primary" value="بسیار عالی!">
                    </form>
                </p>
            </div>
            <?php
        }

        public function inactive_license_notice()
        {
            ?>
            <div class="error notice">
                <h1><?php _e(sprintf("Inactive License %s", $this->title), "ariawp-license"); ?></h1>
                <p><?php _e(sprintf("لایسنس %s (آریا وردپرس) غیرفعال است!", $this->title), "ariawp-license"); ?>
                    <form method="post">
                        <input type="submit" name="delete_license" class="button button-primary" value="حذف لایسنس">
                    </form>
                </p>
            </div>
            <?php
        }

        public function error_activation_notice()
        {
            ?>
            <div class="error notice">
                <h1><?php _e(sprintf("لایسنس %s", $this->title), "ariawp-license"); ?></h1>
                <p><?php _e(sprintf("لایسنس %s (آریا وردپرس) فعال نمی باشد.", $this->title), "ariawp-license"); ?></p>
            </div>
            <?php
        }

        public function max_activation_notice()
        {
            ?>
            <div class="error notice">
                <h1><?php _e(sprintf("License %s", $this->title), "ariawp-license"); ?></h1>
                <p><?php _e(sprintf("License for %s (AriaWp) has been not activated. Because you have reached your maximum activation limits!", $this->title), "ariawp-license"); ?></p>
            </div>
            <?php
        }
    }
}

if(!class_exists("ariawp_license_settings_page"))
{
    $file_path = __DIR__;
    $url_path = str_replace($_SERVER['DOCUMENT_ROOT'], '', $file_path);
    define("ARIAWPLICENSEPLUGINURL", $url_path);

    class ariawp_html5_objects 
    {
        public function select($id, $value, $items, $class, $attr = "")
        {
            $content = "";

            $content .= '<select name="' .
                $id .
                '" value="' .
                $value .
                '" id="' .
                $id .
                '" class="' . 
                $class
                . '" ' . $attr . ' />';

            foreach ($items as $item) {
                $selected =
                    $item["value"] == $value ? 'selected="selected"' : null;

                $content .= '<option value="' .
                    $item["value"] .
                    '" ' .
                    $selected .
                    " >" .
                    $item["name"] .
                    "</option>";
            }

            $content .= "</select>";

            return $content;
        }

        public function span($id, $value, $class, $attr = "")
        {
            $content = "";

            $content .= '<span id="' .
                $id .
                '" class="' . 
                $class
                . '" ' . $attr . ' />';

            $content .= $value;

            $content .= "</span>";

            return $content;
        }

        public function textinput($id, $value, $placeholder, $class, $attr = "")
        {
            echo '<input name="' .
                $id .
                '" value="' .
                $value .
                '" id="' .
                $id .
                '" placeholder="' .
                $placeholder .
                '" type="text" class="regular-text ' . $class . '" ' . $attr . ' />';
        }

        public function fileinput($id, $value, $placeholder, $class, $attr = "")
        {
            echo '<input name="' .
                $id .
                '" value="' .
                $value .
                '" id="' .
                $id .
                '" placeholder="' .
                $placeholder .
                '" type="file" class="' . $class . '" ' . $attr . ' />';
        }

        public function checkbox($id, $value, $text, $class, $attr = "")
        {
            echo '<input name="' .
                $id .
                '" value="true" id="' .
                $id .
                '" type="checkbox" ' .
                ($value == "true" || $value == true ? 'checked="checked"' : "") .
                ' class="regular-text ' .
                $class .
                '" ' .
                $attr . ' />';
                echo '<label for="' . $id . '">' . $text . '</label>';
        }

        public function checkbox_string($id, $value, $text, $class, $attr = "")
        {
            $html = '<input name="' .
                $id .
                '" value="true" id="' .
                $id .
                '" type="checkbox" ' .
                ($value == "true" || $value == true ? 'checked="checked"' : "") .
                ' class="regular-text ' .
                $class .
                '" ' .
                $attr . ' />';
                $html .= '<label for="' . $id . '">' . $text . '</label>';
                
            return $html;
        }

        public function number($id, $value, $placeholder, $class, $min, $max, $step, $attr = "")
        {
            echo '<input name="' .
                $id .
                '" value="' .
                $value .
                '" id="' .
                $id .
                '" placeholder="' .
                $placeholder .
                '" type="number" min="' .
                $min .
                '" max="' .
                $max .
                '" step="' .
                $step .
                '" class="' . 
                $class
                . '" ' . $attr . ' />';
        }

        public function textarea($id, $value, $placeholder, $class, $attr = "cols='40'")
        {
            echo '<textarea name="' .
                $id .
                '" id="' .
                $id .
                '" placeholder="' .
                $placeholder .
                '" class="' . 
                $class
                . '" ' . $attr . '>' . $value . '</textarea>';
        }

        public function select_row_table($id, $value, $name, $items, $attr = "")
        {
            ?>
            <tr>
                <td>
                    <p><?php echo $name; ?></p>
                </td>
                <td>
                    <?php
                        echo $this->select($id, $value, $items, "regular-text", $attr);
                    ?>
                </td>
            </tr>
            <?php
        }

        public function number_row_table($id, $value, $name, $placeholder)
        {
            ?>
            <tr>
                <td>
                    <p><?php echo $name; ?></p>
                </td>
                <td>
                    <?php
                        echo $this->number($id, $value, $placeholder, "", 0, 1000000000, 1);
                    ?>
                </td>
            </tr>
            <?php
        }

        public function textinput_row_table($id, $value, $name, $placeholder, $class)
        {
            ?>
            <tr>
                <td>
                    <p><?php echo $name; ?></p>
                </td>
                <td>
                    <?php
                        echo $this->textinput($id, $value, $placeholder, $class);
                    ?>
                </td>
            </tr>
            <?php
        }

        public function fileinput_row_table($id, $value, $name, $placeholder, $class)
        {
            ?>
            <tr>
                <td>
                    <p><?php echo $name; ?></p>
                </td>
                <td>
                    <?php
                        echo $this->fileinput($id, $value, $placeholder, $class);
                    ?>
                </td>
            </tr>
            <?php
        }

        public function textarea_row_table($id, $value, $name, $placeholder, $class)
        {
            ?>
            <tr>
                <td>
                    <p><?php echo $name; ?></p>
                </td>
                <td>
                    <textarea rows="5" id="<?php echo $id; ?>" name="<?php echo $id; ?>" placeholder="<?php echo $placeholder; ?>" class="regular-text <?php echo $class; ?>"></textarea>
                </td>
            </tr>
            <?php
        }


        public function html_row_table($name, $html)
        {
            ?>
            <tr>
                <td>
                    <p><?php echo $name; ?></p>
                </td>
                <td>
                    <?php
                        echo $html;
                    ?>
                </td>
            </tr>
            <?php
        }

        public function submit_button($id = "submit", $name = "ثبت", $class = "")
        {
            ?>
                <input type="submit" class="button button-primary <?php echo $class; ?>" name="<?php echo $id; ?>" value="<?php echo $name; ?>">
            <?php
        }

        public function submit_button_string($id = "submit", $name = "ثبت", $class = "")
        {
            return '<input type="submit" class="button button-primary ' . $class . '" name="' . $id . '" value="' . $name . '">';
        }
        
        public function display_success($text)
        {
            echo '<h3 class="success">' . $text . '</h3>';
        }

        public function display_error($text)
        {
            echo '<h3 class="error">' . $text . '</h3>';
        }
    }

    class ariawp_license_names
    {
        private $prefix;
        private $separator;

        public function __construct($prefix = "license", $separator = "_")
        {
            $this->prefix = "ariawp" . $separator . $prefix;
            $this->separator = $separator;
        }

        function getPrefix()
        {
            return $this->prefix;
        }

        function getSeparator()
        {
            return $this->separator;
        }

        function getField($tabID, $sectionID, $fieldID)
        {
            return $this->prefix .
                $this->separator .
                $tabID .
                $this->separator .
                $sectionID .
                $this->separator .
                $fieldID;
        }

        function getSection($tabID, $sectionID)
        {
            return $this->prefix .
                $this->separator .
                $tabID .
                $this->separator .
                $sectionID;
        }

        function getSettings($tabID)
        {
            return $this->prefix . $this->separator . $tabID;
        }
        
        function getSessionsPrefix()
        {
            return $this->prefix . $this->separator;
        }
    }

    class ariawp_license_menu
    {
        private $plugin;
        private $title;
        private $info;
        private $icon;
        private $capability;
        private $position;
        private $names;
        private $tabs;
        private $fields;
        private $scripts;
        private $submit;
        private $custom;

        private $menuSlug;
        private $defaultTab;

        public function reset_notice()
        {
            ?>
            <div class="updated notice">
                <h1><?php echo $this->title; ?></h1>
                <p><?php _e(sprintf("Settings for %s (AriaWp) has been resetted.", $this->title), "ariawp-license"); ?></p>
            </div>
            <?php
        }

        public function __construct(
            $plugin,
            $title,
            $icon,
            $capability,
            $position,
            $names,
            $tabs,
            $fields,
            $scripts,
            $reset = true,
            $submit = true,
            $custom = false
        ) {
            if (is_admin()) {
                if(count($tabs) > 0 && count($fields) > 0 && $reset == true)
                {
                    array_push($tabs, [
                        "id" => "reset",
                        "name" => __("ریست", "ariawp-license"),
                        "sections" => [["id" => "general", "name" => __("تنظیمات عمومی", "ariawp-license")]],
                    ]);

                    array_push($fields, [
                        "id" => "reset",
                        "tab" => "reset",
                        "section" => "general",
                        "label" => __("ریست تنظیمات", "ariawp-license"),
                        "placeholder" =>__("بازگشت به حالت پیشفرض و حذف همه تغییرات", "ariawp-license"),
                        "desc" =>
                            __("با انتخاب این گزینه و کلیک روی دکمه ذخیره تغییرات، تمامی تظیمات بخش لایسنس به حالت پیشفرض باز می‌گردد."),
                        "type" => "checkbox",
                        "default" => "",
                    ]);
                }

                array_push($scripts, 
                    [
                        "id" => "menu",
                        "type" => "css",
                        "url" => ARIAWPLICENSEPLUGINURL . "assets/menu/css/main.css",
                        "load" => "menu",
                    ],

                    [
                        "id" => "menu",
                        "type" => "javascript",
                        "url" => ARIAWPLICENSEPLUGINURL . "assets/menu/js/main.js",
                        "load" => "menu",
                    ],

                    [
                        "id" => "uploader",
                        "type" => "javascript",
                        "url" => ARIAWPLICENSEPLUGINURL . "assets/menu/js/uploader.js",
                        "load" => "menu",
                    ],
                );

                $this->plugin = $plugin;
                $this->title = $title;
                $this->info = __(sprintf("تنظیمات %s", $title), "ariawp-license");
                $this->icon = $icon;
                $this->capability = $capability;
                $this->position = $position;
                $this->names = $names;
                $this->tabs = $tabs;
                $this->fields = $fields;
                $this->scripts = $scripts;
                $this->submit = $submit;
                $this->custom = $custom;

                $this->menuSlug = $this->names->getPrefix();
                $this->defaultTab = isset($_REQUEST["tab"])
                    ? $_REQUEST["tab"]
                    : "general";

                add_action("admin_menu", [$this, "create_settings"]);
                if($this->custom == false)
                {
                    if (
                        get_option($this->names->getPrefix() . "_installed_before") !=
                            true ||
                        get_option($this->names->getField("reset", "general", "reset")) ==
                            true
                    ) {
                        add_action("admin_notices", [$this, "reset_notice"]);

                        foreach ($this->fields as $field) {
                            update_option(
                                $this->names->getField(
                                    $field["tab"],
                                    $field["section"],
                                    $field["id"]
                                ),
                                $field["default"]
                            );
                        }

                        update_option(
                            $this->names->getPrefix() . "_installed_before",
                            true
                        );
                        update_option(
                            $this->names->getField("reset", "general", "reset"),
                            ""
                        );
                    }

                    add_action("admin_init", [$this, "setup_sections"]);
                    add_action("admin_init", [$this, "setup_fields"]);
                }
                add_action("admin_enqueue_scripts", [$this, "load_scripts"]);
                add_action("wp_enqueue_scripts", [$this, "load_scripts"]);
            }
        }

        function load_scripts($hook_suffix)
        {
            if($this->plugin != "")
            {
                $version = get_plugin_data($this->plugin)["Version"];
            }

            $version = "1.0.0";
            wp_enqueue_script("jquery-ui-core");
            wp_enqueue_style("wp-color-picker");
            wp_enqueue_media();

            foreach ($this->scripts as $script) {
                if (
                    ($script["load"] == "menu" &&
                        isset($_GET["page"]) &&
                        $_GET["page"] == $this->menuSlug) ||
                    $script["load"] == "general"
                ) {
                    if ($script["type"] == "css") {
                        wp_enqueue_style(
                            $this->names->getPrefix() .
                                $this->names->getSeparator() .
                                $script["id"] .
                                $this->names->getSeparator() .
                                "style",
                            $script["url"],
                            [],
                            $version
                        );
                    } elseif ($script["type"] == "javascript") {
                        wp_enqueue_script(
                            $this->names->getPrefix() .
                                $this->names->getSeparator() .
                                $script["id"] .
                                $this->names->getSeparator() .
                                "javascript",
                            $script["url"],
                            [],
                            $version
                        );
                    } elseif ($script["type"] == "datePicker")
                    {
                         $ariawp_license_functions = new ariawp_license_functions();
                         $ariawp_license_functions->load_date_picker(isset($script["main"]) ? $script["main"] : false);
                    }  elseif ($script["type"] == "select2")
                    {
                         $ariawp_license_functions = new ariawp_license_functions();
                         $ariawp_license_functions->load_select2(isset($script["main"]) ? $script["main"] : false);
                    }
                }
            }
        }

        public function create_settings()
        {
            $slug = $this->menuSlug;
            $callback = [$this, "settings_content"];
            add_menu_page(
                $this->info,
                $this->title,
                $this->capability,
                $slug,
                $callback,
                $this->icon,
                $this->position
            );

            foreach ($this->tabs as $tab) {
                add_submenu_page(
                    $slug,
                    $tab["name"],
                    $tab["name"],
                    $this->capability,
                    "admin.php?page=" . $slug . "&tab=" . $tab["id"]
                );
            }

            remove_submenu_page($slug, $slug);
        }

        public function settings_content()
        {
            $selectedTab = isset($_GET["tab"])
                ? $_GET["tab"]
                : $this->defaultTab; ?>
            <div class="wrap">
                <div id="<?php echo $this->menuSlug; ?>">
                    <h1><?php echo $this->info; ?></h1>
                    <?php settings_errors(); ?>
                    <nav class="nav-tab-wrapper">
                        <?php foreach ($this->tabs as $tab) {
                            $class =
                                $selectedTab == $tab["id"]
                                    ? "nav-tab nav-tab-active"
                                    : "nav-tab";
                            echo '<a href="?page=' .
                                $this->menuSlug .
                                "&tab=" .
                                $tab["id"] .
                                '" class="' .
                                $class .
                                '">' .
                                $tab["name"] .
                                "</a>";
                        } ?>
                    </nav>
                    <div class="tab-content" id="<?php echo $selectedTab; ?>">
                    <?php
                        do_action($this->names->getPrefix() . "_before_settings"); 
                        do_action($this->names->getPrefix() . "_" . $selectedTab . "_before_settings"); 

                        if($this->custom == false)
                        {
                            echo '<form method="POST" action="' .
                            esc_url(
                                add_query_arg("tab", $selectedTab, admin_url("options.php"))
                            ) .
                            '">';
                            settings_fields($this->names->getSettings($selectedTab));
                            do_settings_sections($this->names->getSettings($selectedTab));
                            if(count($this->tabs) > 0 && count($this->fields) > 0 && $this->submit == true) submit_button();
                            echo "</form>";
                        }

                        do_action($this->names->getPrefix() . "_after_settings"); 
                        do_action($this->names->getPrefix() . "_" . $selectedTab . "_after_settings"); 
                    ?>
                    </div>
                </div>
            </div>
            
            <?php
        }

        public function setup_sections()
        {
            foreach ($this->tabs as $tab) {
                foreach ($tab["sections"] as $section) {
                    add_settings_section(
                        $this->names->getSection($tab["id"], $section["id"]),
                        $section["name"],
                        [],
                        $this->names->getSettings($tab["id"])
                    );
                }
            }
        }

        public function setup_fields()
        {
            $selectedTab = isset($_GET["tab"]) ? $_GET["tab"] : $this->defaultTab;

            foreach ($this->fields as $field) {
                if ($selectedTab == $field["tab"]) {
                    $fieldID = $this->names->getField(
                        $field["tab"],
                        $field["section"],
                        $field["id"]
                    );
                    $settingsID = $this->names->getSettings($selectedTab);
                    $sectionID = $this->names->getSection(
                        $field["tab"],
                        $field["section"]
                    );

                    add_settings_field(
                        $fieldID,
                        $field["label"],
                        [$this, "field_callback"],
                        $settingsID,
                        $sectionID,
                        $field
                    );
                    register_setting($settingsID, $fieldID);
                }
            }
        }

        public function field_callback($field)
        {
            $ariawp_html5_objects = new ariawp_html5_objects();
            $fieldID = $this->names->getField(
                $field["tab"],
                $field["section"],
                $field["id"]
            );

            $value = get_option($fieldID, "");
            $placeholder = isset($field["placeholder"])
                ? $field["placeholder"]
                : "";

            do_action($fieldID . "_before_field");

            switch ($field["type"]) {
                case "mediaUpload":
                    echo '<div class="ariawp-media-selection">';
                    echo '<div>';
                    echo '<img src="' .
                        $value .
                        '" alt="' .
                        $placeholder .
                        '" class="img_' .
                        $fieldID .
                        '" style="max-width: 25em; height: auto; margin-bottom: 1em;" >';
                    echo "<div>";
                    echo '<input name="' .
                        $fieldID .
                        '" value="' .
                        $value .
                        '" id="' .
                        $fieldID .
                        '" placeholder="' .
                        $placeholder .
                        '" class="regular-text url_' .
                        $fieldID .
                        '" >';
                    echo '<input type="button" name="upload-btn" id="upload-btn" class="button-secondary" multiplemedia="' .
                        $field["multipleMedia"] .
                        '" mediatype="' .
                        $field["mediaType"] .
                        '" textinputid="' .
                        $fieldID .
                        '" value="' .
                        $field["buttonText"] .
                        '" >';
                    echo "</div>";
                    echo "</div>";
                    echo "</div>";
                    break;
                case "float":
                    echo $ariawp_html5_objects->number($fieldID, $value, $placeholder, isset($field["class"]) ? $field["class"] : "", $field["min"], $field["max"], $field["step"]);
                    break;
                case "checkbox":
                    $checked = $value == true || $value == "true" ? "checked" : "";
                    echo '<input name="' .
                        $fieldID .
                        '" value="true" id="' .
                        $fieldID .
                        '" type="checkbox" ' .
                        $checked .
                        "/>";
                    echo '<label for="' .
                        $fieldID .
                        '">' .
                        $placeholder .
                        "</label>";
                    break;
                case "combobox":
                    echo $ariawp_html5_objects->select($fieldID, $value, $field["items"], isset($field["class"]) ? $field["class"] : "");
                    break;
                case "pages":
                    $posts = [];
                    
                    foreach (get_posts(['post_type' => 'page', "numberposts" => -1]) as $post) {
                        array_push($posts, [
                            "value" => $post->ID,
                            "name" => $post->post_title == "" ? "(بدون عنوان - شناسه: " . $post->ID . ")" : $post->post_title,
                        ]);
                    }

                    echo $ariawp_html5_objects->select($fieldID, $value, $posts, isset($field["class"]) ? $field["class"] : "");
                    break;
                case "custompost":
                    $posts = [];
                    
                    foreach (get_posts(['post_type' => $field["post_type"], "numberposts" => -1]) as $post) {
                        array_push($posts, [
                            "value" => $post->ID,
                            "name" => $post->post_title == "" ? "(بدون عنوان - شناسه: " . $post->ID . ")" : $post->post_title,
                        ]);
                    }

                    echo $ariawp_html5_objects->select($fieldID, $value, $posts, isset($field["class"]) ? $field["class"] : "");
                    break;
                case "textarea":
                    echo $ariawp_html5_objects->textarea($fieldID, $value, $placeholder, isset($field["class"]) ? $field["class"] : "");
                    break;
                case "custom":
                    echo apply_filters($fieldID . "_filter", $post_id, $value, $field);
                    break;
                default:
                    echo $ariawp_html5_objects->textinput($fieldID, $value, $placeholder, isset($field["class"]) ? $field["class"] : "");
                    break;
            }

            if (isset($field["desc"])) {
                echo '<p class="description">' . $field["desc"] . "</p>";
            }

            do_action($fieldID . "_after_field");
        }
    }

    class ariawp_license_settings_page
    {
        public function __construct()
        {
            add_action("init", [$this, "init"], 100);
        }

        public function init()
        {
            $names = new ariawp_license_names();

            $tabs = [
                [
                    "id" => "licenses",
                    "name" => __("لایسنس ها", "ariawp-license"),
                    "sections" => [
                        ["id" => "general", "name" => __("عمومی", "ariawp-license")],
                    ],
                ],
            ];

            $fields = apply_filters($names->getPrefix() . $names->getSeparator() . "licenses", []);

            $scripts = [
                [
                    "id" => "admin",
                    "type" => "css",
                    "url" => ARIAWPLICENSEPLUGINURL . "assets/menu/css/admin.css",
                    "load" => "general",
                ],
            ];

            $ariawp_license_menu = new ariawp_license_menu(
                "",
                __("آریا وردپرس", "ariawp-license"),
                "dashicons-superhero",
                "manage_options",
                60,
                $names,
                $tabs,
                $fields,
                $scripts
            );
        }
    }

    class ariawp_license_checker
    {
        public static function is_active($id)
        {
            $license = get_option("ariawp_license_licenses_general_" . $id, false);
            $license_activated = get_option("ariawp_license_licenses_general_" . $id . "_activated", false);
            $license_inactive = get_option("ariawp_license_licenses_general_" . $id . "_inactive", false);

            if($license == false || $license != $license_activated || $license_inactive == true)
            {
                return false;
            }

            return true;
        }
    }

    $ariawp_license_settings_page = new ariawp_license_settings_page();
}