<?php
/**
 * Basic Custom Post Types. Custom Post Types include Team, Clients,
 * Portfolios, Our Story and Testimonials.
 *
 * @package RadiantThemes
 *
 * @wordpress-plugin
 * Plugin Name: RadiantThemes Custom Post Type
 * Description: Basic Custom Post Types. Custom Post Types include  Team, Clients, Portfolios, Our Story and Testimonials.
 * Version: 1.2.2
 * Author: RadiantThemes
 * Author URI: http://www.radiantthemes.com
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: radiantthemes-custom-post-type
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Require files.
require 'short-header.php';
require 'class-radiantthemes-portfolio-colors-metabox.php';
require_once 'mega-menu/class-radiantthemes-menu-walker.php';


require_once 'widget/facebook-page-box/class-radiantthemes-facebook-widget.php';
require_once 'widget/twitter-widget/class-radiantthemes-twitter-widget.php';
require_once 'widget/contact-box/class-radiantthemes-contact-box-widget.php';
require_once 'widget/social-widget/class-radiantthemes-social-widget.php';
require_once 'widget/recent-posts/class-radiantthemes-recent-posts-widget.php';
require_once 'widget/image-box/class-radiantthemes-image-box-widget.php';

/**
 * Remove Notice.
 */
function radiantthemes_unwanted_notice_remove() {
	echo '<style type="text/css">.rs-update-notice-wrap,.vc_license-activation-notice{display:none;}</style>';
}
add_action( 'admin_head', 'radiantthemes_unwanted_notice_remove' );

/**
 * Add custom post types.
 */
function radiantthemes_custom_posts_init() {
	// Localization.
	load_plugin_textdomain( 'radiantthemes-custom-post-type', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );

	// Register the "Testimonial" custom post type.
	$testimonials_labels = array(
		'name'                  => _x( 'بازخورد ها', 'Post type general name', 'radiantthemes-custom-post-type' ),
		'singular_name'         => _x( 'بازخورد ها', 'Post type singular name', 'radiantthemes-custom-post-type' ),
		'menu_name'             => _x( 'بازخورد ها', 'Admin Menu text', 'radiantthemes-custom-post-type' ),
		'name_admin_bar'        => _x( 'بازخورد ها', 'Add New on Toolbar', 'radiantthemes-custom-post-type' ),
		'add_new'               => __( 'افزودن بازخورد جدید', 'radiantthemes-custom-post-type' ),
		'add_new_item'          => __( 'افزودن بازخورد جدید', 'radiantthemes-custom-post-type' ),
		'new_item'              => __( 'بازخورد جدید', 'radiantthemes-custom-post-type' ),
		'edit_item'             => __( 'ویرایش بازخورد', 'radiantthemes-custom-post-type' ),
		'view_item'             => __( 'مشاهده بازخورد', 'radiantthemes-custom-post-type' ),
		'all_items'             => __( 'همه بازخورد ها', 'radiantthemes-custom-post-type' ),
		'search_items'          => __( 'جستجوی بازخوردها', 'radiantthemes-custom-post-type' ),
		'parent_item_colon'     => __( 'مادر بازخورد ها:', 'radiantthemes-custom-post-type' ),
		'not_found'             => __( 'پیدا نشد', 'radiantthemes-custom-post-type' ),
		'not_found_in_trash'    => __( 'پیدا نشد', 'radiantthemes-custom-post-type' ),
		'featured_image'        => _x( 'تصویر کاور مشتری', 'Overrides the "Featured Image" phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'set_featured_image'    => _x( 'تصویر ست کنید', 'Overrides the "Set featured image" phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'remove_featured_image' => _x( 'حذف', 'Overrides the "Remove featured image" phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'use_featured_image'    => _x( 'استفاده به عنوان تصویر مشتری', 'Overrides the "Use as featured image" phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'archives'              => _x( 'آرشیو بازخورد ها', 'The post type archive label used in nav menus. Default "Post Archives". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'insert_into_item'      => _x( 'درح در بازخورد', 'Overrides the "Insert into post"/"Insert into page" phrase (used when inserting media into a post). Added in 4.4', 'radiantthemes-custom-post-type' ),
		'uploaded_to_this_item' => _x( 'آپلود در این بازخورد', 'Overrides the "Uploaded to this post"/"Uploaded to this page" phrase (used when viewing media attached to a post). Added in 4.4', 'radiantthemes-custom-post-type' ),
		'filter_items_list'     => _x( 'لیست فیلتر بازخورد', 'Screen reader text for the filter links heading on the post type listing screen. Default "Filter posts list"/"Filter pages list". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'items_list_navigation' => _x( 'لیست ناوربری بازخورد', 'Screen reader text for the pagination heading on the post type listing screen. Default "Posts list navigation"/"Pages list navigation". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'items_list'            => _x( 'لیست بازخورد', 'Screen reader text for the items list heading on the post type listing screen. Default "Posts list"/"Pages list". Added in 4.4', 'radiantthemes-custom-post-type' ),
	);

	$post_type_testimonial = array(
		'labels'             => $testimonials_labels,
		'public'             => true,
		'publicly_queryable' => false,
		'menu_icon'          => 'dashicons-testimonial',
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array(
			'slug' => 'testimonial',
		),
		'capability_type'    => 'post',
		'has_archive'        => false,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail' ),
	);
	register_post_type( 'testimonial', $post_type_testimonial );

	/**
	 * Register the Testimonial Category taxonomy.
	 */
	$testimonial_label = array(
		'name'                       => _x( 'دسته بندی بازخورد', 'Taxonomy General Name', 'radiantthemes-custom-post-type' ),
		'singular_name'              => _x( 'دسته بازخورد', 'Taxonomy Singular Name', 'radiantthemes-custom-post-type' ),
		'menu_name'                  => __( 'دسته بازخورد', 'radiantthemes-custom-post-type' ),
		'all_items'                  => __( 'همه دسته های بازخورد', 'radiantthemes-custom-post-type' ),
		'parent_item'                => __( 'دسته مادر بازخورد', 'radiantthemes-custom-post-type' ),
		'parent_item_colon'          => __( 'دسته مادر بازخورد:', 'radiantthemes-custom-post-type' ),
		'new_item_name'              => __( 'نام دسته بازخورد جدید', 'radiantthemes-custom-post-type' ),
		'add_new_item'               => __( 'افزودن دسته بازخورد جدید', 'radiantthemes-custom-post-type' ),
		'edit_item'                  => __( 'ویرایش دسته', 'radiantthemes-custom-post-type' ),
		'update_item'                => __( 'به روزرسانی دسته', 'radiantthemes-custom-post-type' ),
		'view_item'                  => __( 'مشاهده دسته', 'radiantthemes-custom-post-type' ),
		'separate_items_with_commas' => __( 'دسته ها را با کامای انگلیسی جدا کنید', 'radiantthemes-custom-post-type' ),
		'add_or_remove_items'        => __( 'حذف یا اضافه کردن دسته', 'radiantthemes-custom-post-type' ),
		'choose_from_most_used'      => __( 'انتخاب از بیشتر استفاده شده', 'radiantthemes-custom-post-type' ),
		'popular_items'              => __( 'دسته های محبوب', 'radiantthemes-custom-post-type' ),
		'search_items'               => __( 'جستجوی دسته ها', 'radiantthemes-custom-post-type' ),
		'not_found'                  => __( 'پیدا نشد', 'radiantthemes-custom-post-type' ),
		'no_terms'                   => __( 'بدون دسته', 'radiantthemes-custom-post-type' ),
		'items_list'                 => __( 'لیست دسته های بازخورد ها', 'radiantthemes-custom-post-type' ),
		'items_list_navigation'      => __( 'لیست ناوبری دسته بازخورد ها', 'radiantthemes-custom-post-type' ),
	);

	$post_type_testimonial = array(
		'labels'            => $testimonial_label,
		'hierarchical'      => true,
		'public'            => false,
		'show_ui'           => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => true,
		'show_tagcloud'     => true,
	);
	register_taxonomy( 'testimonial-category', array( 'testimonial' ), $post_type_testimonial );

	// Register the "Team" custom post type.
	$team_labels = array(
		'name'                  => _x( 'تیم', 'Post type general name', 'radiantthemes-custom-post-type' ),
		'singular_name'         => _x( 'تیم', 'Post type singular name', 'radiantthemes-custom-post-type' ),
		'menu_name'             => _x( 'تیم', 'Admin Menu text', 'radiantthemes-custom-post-type' ),
		'name_admin_bar'        => _x( 'تیم', 'Add New on Toolbar', 'radiantthemes-custom-post-type' ),
		'add_new'               => __( 'افزودن تیم جدید', 'radiantthemes-custom-post-type' ),
		'add_new_item'          => __( 'افزودن تیم جدید', 'radiantthemes-custom-post-type' ),
		'new_item'              => __( 'تیم جدید', 'radiantthemes-custom-post-type' ),
		'edit_item'             => __( 'ویرایش تیم', 'radiantthemes-custom-post-type' ),
		'view_item'             => __( 'مشاهده تیم', 'radiantthemes-custom-post-type' ),
		'all_items'             => __( 'همه تیم ها', 'radiantthemes-custom-post-type' ),
		'search_items'          => __( 'جستجوی تیم', 'radiantthemes-custom-post-type' ),
		'parent_item_colon'     => __( 'تیم مادر:', 'radiantthemes-custom-post-type' ),
		'not_found'             => __( 'تیم پیدا نشد.', 'radiantthemes-custom-post-type' ),
		'not_found_in_trash'    => __( 'پیدا نشد', 'radiantthemes-custom-post-type' ),
		'featured_image'        => _x( 'تصویر عضو تیم', 'Overrides the "Featured Image", phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'set_featured_image'    => _x( 'تصویر عضو را ست کنید', 'Overrides the "Set featured image", phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'remove_featured_image' => _x( 'حذف تصویر', 'Overrides the "Remove featured image" phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'use_featured_image'    => _x( 'استفاده به عنوان تصویر عضو', 'Overrides the "Use as featured image" phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'archives'              => _x( 'آرشیو تیم', 'The post type archive label used in nav menus. Default "Post Archives". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'insert_into_item'      => _x( 'درج در تیم', 'Overrides the "Insert into post"/"Insert into page" phrase (used when inserting media into a post). Added in 4.4', 'radiantthemes-custom-post-type' ),
		'uploaded_to_this_item' => _x( 'آپلود شده در تیم', 'Overrides the "Uploaded to this post"/"Uploaded to this page" phrase (used when viewing media attached to a post). Added in 4.4', 'radiantthemes-custom-post-type' ),
		'filter_items_list'     => _x( 'لیست فیلتر تیم', 'Screen reader text for the filter links heading on the post type listing screen. Default "Filter posts list"/"Filter pages list". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'items_list_navigation' => _x( 'لیست ناوبری تیم', 'Screen reader text for the pagination heading on the post type listing screen. Default "Posts list navigation"/"Pages list navigation". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'items_list'            => _x( 'لیست تیم', 'Screen reader text for the items list heading on the post type listing screen. Default "Posts list"/"Pages list". Added in 4.4', 'radiantthemes-custom-post-type' ),
	);

	$post_type_team = array(
		'labels'             => $team_labels,
		'public'             => true,
		'publicly_queryable' => true,
		'menu_icon'          => 'dashicons-groups',
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array(
			'slug' => 'team',
		),
		'capability_type'    => 'post',
		'has_archive'        => false,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
	);
	register_post_type( 'team', $post_type_team );

	/**
	 * Register the "Profession" taxonomy.
	 */
	$profession_label = array(
		'name'                       => _x( 'حرفه ها', 'Taxonomy General Name', 'radiantthemes-custom-post-type' ),
		'singular_name'              => _x( 'حرفه ها', 'Taxonomy Singular Name', 'radiantthemes-custom-post-type' ),
		'menu_name'                  => __( 'حرفه ها', 'radiantthemes-custom-post-type' ),
		'all_items'                  => __( 'همه حرفه ها', 'radiantthemes-custom-post-type' ),
		'parent_item'                => __( 'حرفه مادر', 'radiantthemes-custom-post-type' ),
		'parent_item_colon'          => __( 'حرفه مادر:', 'radiantthemes-custom-post-type' ),
		'new_item_name'              => __( 'نام حرفه جدید', 'radiantthemes-custom-post-type' ),
		'add_new_item'               => __( 'افزودن حرفه جدید', 'radiantthemes-custom-post-type' ),
		'edit_item'                  => __( 'ویرایش حرفه', 'radiantthemes-custom-post-type' ),
		'update_item'                => __( 'به روزرسانی حرفه', 'radiantthemes-custom-post-type' ),
		'view_item'                  => __( 'مشاهده حرفه', 'radiantthemes-custom-post-type' ),
		'separate_items_with_commas' => __( 'با کامای انگلیسی جدا کنید', 'radiantthemes-custom-post-type' ),
		'add_or_remove_items'        => __( 'حذف یا اضافه کردن', 'radiantthemes-custom-post-type' ),
		'choose_from_most_used'      => __( 'انتخاب بیشتر استفاده شده', 'radiantthemes-custom-post-type' ),
		'popular_items'              => __( 'محبوب ترین حرفه ها', 'radiantthemes-custom-post-type' ),
		'search_items'               => __( 'جستجوی حرفه ها', 'radiantthemes-custom-post-type' ),
		'not_found'                  => __( 'پیدا نشد', 'radiantthemes-custom-post-type' ),
		'no_terms'                   => __( 'بدون حرفه ', 'radiantthemes-custom-post-type' ),
		'items_list'                 => __( 'لیست حرفه ها', 'radiantthemes-custom-post-type' ),
		'items_list_navigation'      => __( 'ناوبری لیست حرفه ها', 'radiantthemes-custom-post-type' ),
	);

	$post_type_professional = array(
		'labels'            => $profession_label,
		'hierarchical'      => true,
		'public'            => false,
		'show_ui'           => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => true,
		'show_tagcloud'     => true,
	);
	register_taxonomy( 'profession', array( 'team' ), $post_type_professional );

	// Register the "Portfolio" custom post type.
	$portfolio_labels = array(
		'name'                  => _x( 'نمونه کار', 'Post type general name', 'radiantthemes-custom-post-type' ),
		'singular_name'         => _x( 'نمونه کار', 'Post type singular name', 'radiantthemes-custom-post-type' ),
		'menu_name'             => _x( 'نمونه کار', 'Admin Menu text', 'radiantthemes-custom-post-type' ),
		'name_admin_bar'        => _x( 'نمونه کار', 'Add New on Toolbar', 'radiantthemes-custom-post-type' ),
		'add_new'               => __( 'افزودن نمونه کار جدید', 'radiantthemes-custom-post-type' ),
		'add_new_item'          => __( 'افزودن نمونه کار جدید', 'radiantthemes-custom-post-type' ),
		'new_item'              => __( 'نمونه کار جدید', 'radiantthemes-custom-post-type' ),
		'edit_item'             => __( 'ویرایش نمونه کار', 'radiantthemes-custom-post-type' ),
		'view_item'             => __( 'مشاهده نمونه کار', 'radiantthemes-custom-post-type' ),
		'all_items'             => __( 'همه نمونه کارها', 'radiantthemes-custom-post-type' ),
		'search_items'          => __( 'جستجوی نمونه کار', 'radiantthemes-custom-post-type' ),
		'parent_item_colon'     => __( 'نمونه کار مادر:', 'radiantthemes-custom-post-type' ),
		'not_found'             => __( 'نمونه کار پیدا نشد.', 'radiantthemes-custom-post-type' ),
		'not_found_in_trash'    => __( 'پیدا نشد', 'radiantthemes-custom-post-type' ),
		'featured_image'        => _x( 'تصویر نمونه کار', 'Overrides the "Featured Image", phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'set_featured_image'    => _x( 'تصویر نمونه کار را انتخاب کنید', 'Overrides the "Set featured image", phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'remove_featured_image' => _x( 'حذف تصویر', 'Overrides the "Remove featured image" phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'use_featured_image'    => _x( 'انتخاب به عنوان تصویر', 'Overrides the "Use as featured image" phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'archives'              => _x( 'آرشیو نمونه کار', 'The post type archive label used in nav menus. Default "Post Archives". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'insert_into_item'      => _x( 'درج در نمونه کار', 'Overrides the "Insert into post"/"Insert into page" phrase (used when inserting media into a post). Added in 4.4', 'radiantthemes-custom-post-type' ),
		'uploaded_to_this_item' => _x( 'آپلود شده در این نمونه کار', 'Overrides the "Uploaded to this post"/"Uploaded to this page" phrase (used when viewing media attached to a post). Added in 4.4', 'radiantthemes-custom-post-type' ),
		'filter_items_list'     => _x( 'لیست فیلتر نمونه کار', 'Screen reader text for the filter links heading on the post type listing screen. Default "Filter posts list"/"Filter pages list". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'items_list_navigation' => _x( 'لیست ناوبری نمونه کار', 'Screen reader text for the pagination heading on the post type listing screen. Default "Posts list navigation"/"Pages list navigation". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'items_list'            => _x( 'لیست نمونه کار', 'Screen reader text for the items list heading on the post type listing screen. Default "Posts list"/"Pages list". Added in 4.4', 'radiantthemes-custom-post-type' ),
	);

	$post_type_portfolio = array(
		'labels'             => $portfolio_labels,
		'public'             => true,
		'publicly_queryable' => true,
		'menu_icon'          => 'dashicons-images-alt2',
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array(
			'slug' => 'portfolio',
		),
		'capability_type'    => 'post',
		'has_archive'        => false,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt', 'page-attributes' ),
	);
	register_post_type( 'portfolio', $post_type_portfolio );

	/**
	 * Register the "Portfolio Categories" custom post type.
	 */
	$category_label = array(
		'name'                       => _x( 'دسته بندی نمونه کار', 'Taxonomy General Name', 'radiantthemes-custom-post-type' ),
		'singular_name'              => _x( 'دسته بندی نمونه کار', 'Taxonomy Singular Name', 'radiantthemes-custom-post-type' ),
		'menu_name'                  => __( 'دسته بندی نمونه کار', 'radiantthemes-custom-post-type' ),
		'all_items'                  => __( 'همه نمونه کار ها', 'radiantthemes-custom-post-type' ),
		'parent_item'                => __( 'دسته نمونه کار مادر', 'radiantthemes-custom-post-type' ),
		'parent_item_colon'          => __( 'دسته نمونه کار مادر:', 'radiantthemes-custom-post-type' ),
		'new_item_name'              => __( 'نام دسته جدید', 'radiantthemes-custom-post-type' ),
		'add_new_item'               => __( 'افزودن دسته جدید', 'radiantthemes-custom-post-type' ),
		'edit_item'                  => __( 'ویرایش دسته', 'radiantthemes-custom-post-type' ),
		'update_item'                => __( 'به روزرسانی دسته', 'radiantthemes-custom-post-type' ),
		'view_item'                  => __( 'مشاهده دسته', 'radiantthemes-custom-post-type' ),
		'separate_items_with_commas' => __( 'با کامای انگلیسی جدا کنید', 'radiantthemes-custom-post-type' ),
		'add_or_remove_items'        => __( 'حدف یا افزودن', 'radiantthemes-custom-post-type' ),
		'choose_from_most_used'      => __( 'انتخاب کنید از بیشتر انتخاب شدده ها', 'radiantthemes-custom-post-type' ),
		'popular_items'              => __( 'محبوب ترین دسته ها', 'radiantthemes-custom-post-type' ),
		'search_items'               => __( 'جستجوی دسته نمونه کار', 'radiantthemes-custom-post-type' ),
		'not_found'                  => __( 'پیدا نشد', 'radiantthemes-custom-post-type' ),
		'no_terms'                   => __( 'بدون دسته', 'radiantthemes-custom-post-type' ),
		'items_list'                 => __( 'دسته های نمونه کار', 'radiantthemes-custom-post-type' ),
		'items_list_navigation'      => __( 'لیست ناوبری نمونه کار', 'radiantthemes-custom-post-type' ),
	);

	$post_type_category = array(
		'labels'            => $category_label,
		'hierarchical'      => true,
		'public'            => false,
		'show_ui'           => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => true,
		'show_tagcloud'     => true,
	);
	register_taxonomy( 'portfolio-category', array( 'portfolio' ), $post_type_category );

	// Register the "Clients" custom post type.
	$clients_labels = array(
		'name'                  => _x( 'مشتری', 'Post type general name', 'radiantthemes-custom-post-type' ),
		'singular_name'         => _x( 'مشتری', 'Post type singular name', 'radiantthemes-custom-post-type' ),
		'menu_name'             => _x( 'مشتری ها', 'Admin Menu text', 'radiantthemes-custom-post-type' ),
		'name_admin_bar'        => _x( 'مشتری', 'Add New on Toolbar', 'radiantthemes-custom-post-type' ),
		'add_new'               => __( 'افزودن مشتری جدید', 'radiantthemes-custom-post-type' ),
		'add_new_item'          => __( 'افزودن مشتری جدید', 'radiantthemes-custom-post-type' ),
		'new_item'              => __( 'New Clients', 'radiantthemes-custom-post-type' ),
		'edit_item'             => __( 'Edit Clients', 'radiantthemes-custom-post-type' ),
		'view_item'             => __( 'View Clients', 'radiantthemes-custom-post-type' ),
		'all_items'             => __( 'همه مشتری ها', 'radiantthemes-custom-post-type' ),
		'search_items'          => __( 'Search Clients', 'radiantthemes-custom-post-type' ),
		'parent_item_colon'     => __( 'Parent Clients:', 'radiantthemes-custom-post-type' ),
		'not_found'             => __( 'No Clients found.', 'radiantthemes-custom-post-type' ),
		'not_found_in_trash'    => __( 'No Clients found in Trash.', 'radiantthemes-custom-post-type' ),
		'featured_image'        => _x( 'Client Cover Image', 'Overrides the "Featured Image", phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'set_featured_image'    => _x( 'تصویر مشتری', 'Overrides the "Set featured image", phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'remove_featured_image' => _x( 'حذف', 'Overrides the "Remove featured image" phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'use_featured_image'    => _x( 'Use as Client image', 'Overrides the "Use as featured image" phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'archives'              => _x( 'Clients archives', 'The post type archive label used in nav menus. Default "Post Archives". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'insert_into_item'      => _x( 'Insert into Client', 'Overrides the "Insert into post"/"Insert into page" phrase (used when inserting media into a post). Added in 4.4', 'radiantthemes-custom-post-type' ),
		'uploaded_to_this_item' => _x( 'Uploaded to this Client', 'Overrides the "Uploaded to this post"/"Uploaded to this page" phrase (used when viewing media attached to a post). Added in 4.4', 'radiantthemes-custom-post-type' ),
		'filter_items_list'     => _x( 'Filter Clients list', 'Screen reader text for the filter links heading on the post type listing screen. Default "Filter posts list"/"Filter pages list". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'items_list_navigation' => _x( 'Clients list navigation', 'Screen reader text for the pagination heading on the post type listing screen. Default "Posts list navigation"/"Pages list navigation". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'items_list'            => _x( 'لیست مشتری ها', 'Screen reader text for the items list heading on the post type listing screen. Default "Posts list"/"Pages list". Added in 4.4', 'radiantthemes-custom-post-type' ),
	);

	$post_type_client = array(
		'labels'             => $clients_labels,
		'public'             => true,
		'publicly_queryable' => false,
		'menu_icon'          => 'dashicons-businessman',
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array(
			'slug' => 'client',
		),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'thumbnail' ),
	);
	register_post_type( 'client', $post_type_client );

	/**
	 * Register the Client Category taxonomy.
	 */
	$client_label = array(
		'name'                       => _x( 'دسته بندی مشتری ها', 'Taxonomy General Name', 'radiantthemes-custom-post-type' ),
		'singular_name'              => _x( 'دسته مشتری', 'Taxonomy Singular Name', 'radiantthemes-custom-post-type' ),
		'menu_name'                  => __( 'دسته مشتری', 'radiantthemes-custom-post-type' ),
		'all_items'                  => __( 'همه دسته ها', 'radiantthemes-custom-post-type' ),
		'parent_item'                => __( 'مادر', 'radiantthemes-custom-post-type' ),
		'parent_item_colon'          => __( 'مادر:', 'radiantthemes-custom-post-type' ),
		'new_item_name'              => __( 'نام دسته', 'radiantthemes-custom-post-type' ),
		'add_new_item'               => __( 'افزودن', 'radiantthemes-custom-post-type' ),
		'edit_item'                  => __( 'ویراایش', 'radiantthemes-custom-post-type' ),
		'update_item'                => __( 'به روزرسانی', 'radiantthemes-custom-post-type' ),
		'view_item'                  => __( 'مشاهده', 'radiantthemes-custom-post-type' ),
		'separate_items_with_commas' => __( 'با کامای انگلیسی جدا کنید', 'radiantthemes-custom-post-type' ),
		'add_or_remove_items'        => __( 'افزودن یا حذف', 'radiantthemes-custom-post-type' ),
		'choose_from_most_used'      => __( 'انتخاب از بیشتر انتخاب شده ها', 'radiantthemes-custom-post-type' ),
		'popular_items'              => __( 'انتخاب از محبوب ها', 'radiantthemes-custom-post-type' ),
		'search_items'               => __( 'جستجوی دسته ها', 'radiantthemes-custom-post-type' ),
		'not_found'                  => __( 'پیدا نشد', 'radiantthemes-custom-post-type' ),
		'no_terms'                   => __( 'بدون دسته', 'radiantthemes-custom-post-type' ),
		'items_list'                 => __( 'لیست دسته های مشتری', 'radiantthemes-custom-post-type' ),
		'items_list_navigation'      => __( 'لیست ناوبری', 'radiantthemes-custom-post-type' ),
	);

	$post_type_client = array(
		'labels'            => $client_label,
		'hierarchical'      => true,
		'public'            => false,
		'show_ui'           => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => true,
		'show_tagcloud'     => true,
	);
	register_taxonomy( 'client-category', array( 'client' ), $post_type_client );
    	// Register the "Case Studies" custom post type.
	$case_study_labels = array(
		'name'                  => _x( 'پرونده مطالعات', 'Post type general name', 'radiantthemes-custom-post-type' ),
		'singular_name'         => _x( 'پرونده مطالعات', 'Post type singular name', 'radiantthemes-custom-post-type' ),
		'menu_name'             => _x( 'پرونده مطالعه', 'Admin Menu text', 'radiantthemes-custom-post-type' ),
		'name_admin_bar'        => _x( 'پرونده مطالعه', 'Add New on Toolbar', 'radiantthemes-custom-post-type' ),
		'add_new'               => __( 'افزودن پرونده مطالعه', 'radiantthemes-custom-post-type' ),
		'add_new_item'          => __( 'افزودن پرونده مطالعه', 'radiantthemes-custom-post-type' ),
		'new_item'              => __( 'پرونده مطالعه جدید', 'radiantthemes-custom-post-type' ),
		'edit_item'             => __( 'ویرایش', 'radiantthemes-custom-post-type' ),
		'view_item'             => __( 'مشاهده', 'radiantthemes-custom-post-type' ),
		'all_items'             => __( 'همه', 'radiantthemes-custom-post-type' ),
		'search_items'          => __( 'جستجو', 'radiantthemes-custom-post-type' ),
		'parent_item_colon'     => __( 'مادر', 'radiantthemes-custom-post-type' ),
		'not_found'             => __( 'پیدا نشد', 'radiantthemes-custom-post-type' ),
		'not_found_in_trash'    => __( 'در سطل زباله پیدا نشد', 'radiantthemes-custom-post-type' ),
		'featured_image'        => _x( 'تصویر پرونده مطالعه', 'Overrides the "Featured Image", phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'set_featured_image'    => _x( 'تنظیم تصویر', 'Overrides the "Set featured image", phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'remove_featured_image' => _x( 'حذف', 'Overrides the "Remove featured image" phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'use_featured_image'    => _x( 'استفاده از تصویر', 'Overrides the "Use as featured image" phrase for this post type. Added in 4.3', 'radiantthemes-custom-post-type' ),
		'archives'              => _x( 'آرشیو', 'The post type archive label used in nav menus. Default "Post Archives". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'insert_into_item'      => _x( 'درج کردن', 'Overrides the "Insert into post"/"Insert into page" phrase (used when inserting media into a post). Added in 4.4', 'radiantthemes-custom-post-type' ),
		'uploaded_to_this_item' => _x( 'آپلود شده در اینجا', 'Overrides the "Uploaded to this post"/"Uploaded to this page" phrase (used when viewing media attached to a post). Added in 4.4', 'radiantthemes-custom-post-type' ),
		'filter_items_list'     => _x( 'لیست فیلنر', 'Screen reader text for the filter links heading on the post type listing screen. Default "Filter posts list"/"Filter pages list". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'items_list_navigation' => _x( 'لیست ناوبری', 'Screen reader text for the pagination heading on the post type listing screen. Default "Posts list navigation"/"Pages list navigation". Added in 4.4', 'radiantthemes-custom-post-type' ),
		'items_list'            => _x( 'لیست پرونده ها', 'Screen reader text for the items list heading on the post type listing screen. Default "Posts list"/"Pages list". Added in 4.4', 'radiantthemes-custom-post-type' ),
	);

	$post_type_case_study = array(
		'labels'             => $case_study_labels,
		'public'             => true,
		'publicly_queryable' => true,
		'menu_icon'          => 'dashicons-images-alt2',
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array(
			'slug' => 'case-studies',
		),
		'capability_type'    => 'post',
		'has_archive'        => false,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
	);
	register_post_type( 'case-studies', $post_type_case_study );

	/**
	 * Register the "Case Study Categories" custom post type.
	 */
	$case_study_category_label = array(
		'name'                       => _x( 'دسته های پرونده ها', 'Taxonomy General Name', 'radiantthemes-custom-post-type' ),
		'singular_name'              => _x( 'دسته پرونده', 'Taxonomy Singular Name', 'radiantthemes-custom-post-type' ),
		'menu_name'                  => __( 'دسته پرونده', 'radiantthemes-custom-post-type' ),
		'all_items'                  => __( 'همه دسته ها', 'radiantthemes-custom-post-type' ),
		'parent_item'                => __( 'مادر', 'radiantthemes-custom-post-type' ),
		'parent_item_colon'          => __( 'مادر:', 'radiantthemes-custom-post-type' ),
		'new_item_name'              => __( 'نام دسته', 'radiantthemes-custom-post-type' ),
		'add_new_item'               => __( 'افزودن دسته', 'radiantthemes-custom-post-type' ),
		'edit_item'                  => __( 'ویرایش', 'radiantthemes-custom-post-type' ),
		'update_item'                => __( 'به روزرسانی', 'radiantthemes-custom-post-type' ),
		'view_item'                  => __( 'مشاهده', 'radiantthemes-custom-post-type' ),
		'separate_items_with_commas' => __( 'با کاما جدا کنید', 'radiantthemes-custom-post-type' ),
		'add_or_remove_items'        => __( 'افزودن یا حذف', 'radiantthemes-custom-post-type' ),
		'choose_from_most_used'      => __( 'از بیشتر انتخاب شده ها انتخاب کنید', 'radiantthemes-custom-post-type' ),
		'popular_items'              => __( 'انتخاب از محبوب ها', 'radiantthemes-custom-post-type' ),
		'search_items'               => __( 'جستجوی دسته ها', 'radiantthemes-custom-post-type' ),
		'not_found'                  => __( 'پیدا نشد', 'radiantthemes-custom-post-type' ),
		'no_terms'                   => __( 'بدون دسته', 'radiantthemes-custom-post-type' ),
		'items_list'                 => __( 'لیست دسته ها', 'radiantthemes-custom-post-type' ),
		'items_list_navigation'      => __( 'لیست ناوبری', 'radiantthemes-custom-post-type' ),
	);

	$post_type_category_case_study = array(
		'labels'            => $case_study_category_label,
		'hierarchical'      => true,
		'public'            => false,
		'show_ui'           => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => true,
		'show_tagcloud'     => true,
	);
	register_taxonomy( 'case-study-category', array( 'case-studies' ), $post_type_category_case_study );

	// Register the Mega Menu custom post type.
	$mega_menu_labels = array(
		'name'               => esc_html__( 'مگامنو', 'radiantthemes-custom-post-type' ),
		'all_items'          => esc_html__( 'مگامنو', 'radiantthemes-custom-post-type' ),
		'singular_name'      => esc_html__( 'مگامنو', 'radiantthemes-custom-post-type' ),
		'add_new'            => esc_html__( 'افزودن جدید', 'radiantthemes-custom-post-type' ),
		'add_new_item'       => esc_html__( 'افزودن جدید', 'radiantthemes-custom-post-type' ),
		'edit_item'          => esc_html__( 'ویرایش', 'radiantthemes-custom-post-type' ),
		'new_item'           => esc_html__( 'افزودن مگامنو', 'radiantthemes-custom-post-type' ),
		'view_item'          => esc_html__( 'مشاهده', 'radiantthemes-custom-post-type' ),
		'search_items'       => esc_html__( 'جستجو..', 'radiantthemes-custom-post-type' ),
		'not_found'          => esc_html__( 'پیدا نشد', 'radiantthemes-custom-post-type' ),
		'not_found_in_trash' => esc_html__( 'پیدا نشد', 'radiantthemes-custom-post-type' ),
	);

	$mega_menu_args = array(
		'labels'          => $mega_menu_labels,
		'public'          => true,
		'show_ui'         => true,
		'capability_type' => 'post',
		'hierarchical'    => true,
		'rewrite'         => array(
			'slug' => 'mega_menus',
		),
		'supports'        => array(
			'title',
			'editor',
		),
		'menu_icon'       => 'dashicons-editor-table',
	);
	register_post_type( 'mega_menu', $mega_menu_args );
}

/**
 * Hook into the 'init' action so that the function
 * Containing our post type registration is not
 * unnecessarily executed.
 */
add_action( 'init', 'radiantthemes_custom_posts_init' );

/**
 * Add meta box for testimonials
 *
 * @param post $post The post object.
 * @link https://codex.wordpress.org/Plugin_API/Action_Reference/add_meta_boxes
 */
function testimonial_add_meta_boxes( $post ) {
	add_meta_box(
		'testimonial_meta_box',
		esc_html__( 'CLIENT INFORMATION', 'radiantthemes-custom-post-type' ),
		'testimonial_build_meta_box',
		'testimonial',
		'normal',
		'high'
	);
}
add_action( 'add_meta_boxes_testimonial', 'testimonial_add_meta_boxes' );

/**
 * Build custom field meta box
 *
 * @param post $post The post object.
 */
function testimonial_build_meta_box( $post ) {
	// make sure the form request comes from WordPress.
	wp_nonce_field( basename( __FILE__ ), 'testimonial_meta_box_nonce' );

	// retrieve the _testimonial_designation current value.
	$current_designation = get_post_meta( $post->ID, '_testimonial_designation', true );
	?>
	<div class='inside'>

		<h3><?php esc_html_e( 'Designation', 'radiantthemes-custom-post-type' ); ?></h3>
		<input type="text" class="widefat" name="designation" value="<?php echo esc_attr( $current_designation ); ?>" />

	</div>
	<?php
}

/**
 * Store custom field meta box data
 *
 * @param int $post_id The post ID.
 * @link https://codex.wordpress.org/Plugin_API/Action_Reference/save_post
 */
function testimonial_save_meta_box_data( $post_id ) {
	// verify meta box nonce.
	if ( ! isset( $_POST['testimonial_meta_box_nonce'] ) || ! wp_verify_nonce( sanitize_key( $_POST['testimonial_meta_box_nonce'] ), basename( __FILE__ ) ) ) { // Input var okay.
		return;
	}
	// return if autosave.
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Check the user's permissions.
	if ( ! current_user_can( 'edit_post', $post_id ) ) {
		return;
	}
	// store custom fields values
	// designation string.
	if ( isset( $_REQUEST['designation'] ) ) { // Input var okay.
		update_post_meta( $post_id, '_testimonial_designation', sanitize_text_field( wp_unslash( $_POST['designation'] ) ) ); // Input var okay.
	}
}
add_action( 'save_post_testimonial', 'testimonial_save_meta_box_data' );
/**
 * Add meta box for team
 *
 * @param post $post The post object.
 * @link https://codex.wordpress.org/Plugin_API/Action_Reference/add_meta_boxes
 */
function team_add_meta_boxes( $post ) {
	add_meta_box(
		'team_meta_box',
		__( 'PERSON INFORMATION', 'radiantthemes-custom-post-type' ),
		'team_build_meta_box',
		'team',
		'normal',
		'high'
	);
}
add_action( 'add_meta_boxes_team', 'team_add_meta_boxes' );

/**
 * Build custom field meta box
 *
 * @param post $post The post object.
 */
function team_build_meta_box( $post ) {
	// make sure the form request comes from WordPress.
	wp_nonce_field( basename( __FILE__ ), 'team_meta_box_nonce' );

	// retrieve the _team_facebook current value.
	$current_phone = get_post_meta( $post->ID, '_team_phone', true );

	// retrieve the _team_facebook current value.
	$current_email = get_post_meta( $post->ID, '_team_email', true );

	// retrieve the _team_facebook current value.
	$current_facebook = get_post_meta( $post->ID, '_team_facebook', true );

	// retrieve the _team_twitter current value.
	$current_twitter = get_post_meta( $post->ID, '_team_twitter', true );

	// retrieve the _team_gplus current value.
	$current_gplus = get_post_meta( $post->ID, '_team_gplus', true );

	// retrieve the _team_pinterest current value.
	$current_pinterest = get_post_meta( $post->ID, '_team_pinterest', true );

	?>
	<div class='inside'>
		<h3><?php esc_html_e( 'Phone', 'radiantthemes-custom-post-type' ); ?></h3>
		<p>
			<input type="text" class="widefat" name="phone" value="<?php echo esc_html( $current_phone ); ?>" />
		</p>

		<h3><?php esc_html_e( 'Email', 'radiantthemes-custom-post-type' ); ?></h3>
		<p>
			<input type="text" class="widefat" name="email" value="<?php echo sanitize_email( $current_email ); ?>" />
		</p>

		<h3><?php esc_html_e( 'Facebook Link', 'radiantthemes-custom-post-type' ); ?></h3>
		<p>
			<input type="text" class="widefat" name="facebook" value="<?php echo esc_url( $current_facebook ); ?>" />
		</p>

		<h3><?php esc_html_e( 'Twitter Link', 'radiantthemes-custom-post-type' ); ?></h3>
		<p>
			<input type="text" class="widefat" name="twitter" value="<?php echo esc_url( $current_twitter ); ?>" />
		</p>

		<h3><?php esc_html_e( 'Google Plus Link', 'radiantthemes-custom-post-type' ); ?></h3>
		<p>
			<input type="text" class="widefat" name="gplus" value="<?php echo esc_url( $current_gplus ); ?>" />
		</p>

		<h3><?php esc_html_e( 'Pinterest Link', 'radiantthemes-custom-post-type' ); ?></h3>
		<p>
			<input type="text" class="widefat" name="pinterest" value="<?php echo esc_url( $current_pinterest ); ?>" />
		</p>
	</div>
	<?php
}

/**
 * Store custom field meta box data
 *
 * @param int $post_id The post ID.
 * @link https://codex.wordpress.org/Plugin_API/Action_Reference/save_post
 */
function team_save_meta_box_data( $post_id ) {
	// verify meta box nonce.
	if ( ! isset( $_POST['team_meta_box_nonce'] ) || ! wp_verify_nonce( sanitize_key( $_POST['team_meta_box_nonce'] ), basename( __FILE__ ) ) ) { // Input var okay.
		return;
	}
	// return if autosave.
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Check the user's permissions.
	if ( ! current_user_can( 'edit_post', $post_id ) ) {
		return;
	}
	// store custom fields values
	// phone link.
	if ( isset( $_REQUEST['phone'] ) ) { // Input var okay.
		update_post_meta( $post_id, '_team_phone', sanitize_text_field( wp_unslash( $_POST['phone'] ) ) ); // Input var okay.
	}
	// store custom fields values
	// phone link.
	if ( isset( $_REQUEST['email'] ) ) { // Input var okay.
		update_post_meta( $post_id, '_team_email', sanitize_text_field( wp_unslash( $_POST['email'] ) ) ); // Input var okay.
	}
	// store custom fields values
	// facebook link.
	if ( isset( $_REQUEST['facebook'] ) ) { // Input var okay.
		update_post_meta( $post_id, '_team_facebook', sanitize_text_field( wp_unslash( $_POST['facebook'] ) ) ); // Input var okay.
	}
	// store custom fields values
	// twitter link.
	if ( isset( $_REQUEST['twitter'] ) ) { // Input var okay.
		update_post_meta( $post_id, '_team_twitter', sanitize_text_field( wp_unslash( $_POST['twitter'] ) ) ); // Input var okay.
	}
	// store custom fields values
	// gplus link.
	if ( isset( $_REQUEST['gplus'] ) ) { // Input var okay.
		update_post_meta( $post_id, '_team_gplus', sanitize_text_field( wp_unslash( $_POST['gplus'] ) ) ); // Input var okay.
	}
	// store custom fields values
	// pinterest link.
	if ( isset( $_REQUEST['pinterest'] ) ) { // Input var okay.
		update_post_meta( $post_id, '_team_pinterest', sanitize_text_field( wp_unslash( $_POST['pinterest'] ) ) ); // Input var okay.
	}
}
add_action( 'save_post_team', 'team_save_meta_box_data' );


/**
 * The following function is fired during plugin activation which calls
 * lcpt_setup_post_types function
 */
function lcpt_install() {
	// trigger our function that registers the custom post type.
	radiantthemes_custom_posts_init();

	// clear the permalinks after the post type has been registered.
	flush_rewrite_rules();
}

/**
 * The following function is fired during plugin deactivation
 */
function lcpt_deactivation() {
	// our post type will be automatically removed, so no need to unregister it
	// clear the permalinks to remove our post type's rules.
	flush_rewrite_rules();
}

register_activation_hook( __FILE__, 'lcpt_install' );
register_deactivation_hook( __FILE__, 'lcpt_deactivation' );